<?php
// Retrieve the raw POST data
$body = file_get_contents('php://input');

// Verify that the payload is not empty
if (!empty($body)) {
    // Decode the JSON payload
    $data = json_decode($body, true);

    // Check if JSON decoding was successful
    if ($data !== null) {
        // Handle the webhook data
        // Here you can process the data received from the webhook endpoint
        // Example: Log the data, update database records, trigger actions, etc.
        // Example: $data['key'] to access specific values in the payload
		
		$secret_token = 'e85dafdd8b3712fee6424abde16b453b684770a3bd9d7db2bad5d2cc6f61b70a';
        $signature = hash_hmac('sha256', json_encode($data['payload']), $secret_token);
        
		if( isset($data['HTTP_MEETHOUR_SIGNATURE']) && $data['HTTP_MEETHOUR_SIGNATURE'] == $signature)
		{
			// Log the received data
			file_put_contents('./webhook.log', date('Y-m-d H:i:s') . ' - Webhook data received: ' . print_r($data['payload'], true) . PHP_EOL, FILE_APPEND);

			// Send a response to acknowledge receipt (optional)
			http_response_code(200);
			echo 'Webhook data received successfully. ';
		}
		else {
			 // JSON decoding failed
			http_response_code(400);
			echo 'Error: Invalid JSON payload. Signature Not Matched  Header sign: ' . ((isset($data['HTTP_MEETHOUR_SIGNATURE']) && $data['HTTP_MEETHOUR_SIGNATURE'])?$data['HTTP_MEETHOUR_SIGNATURE']:'Not Set') . '  LMNOP sign: ' . ((isset($_SERVER['HTTP_LMNOP']) && $_SERVER['HTTP_LMNOP'])?$_SERVER['HTTP_LMNOP']:'Not Set');;
		}
			
    } else {
        // JSON decoding failed
        http_response_code(400);
        echo 'Error: Invalid JSON payload.';
    }
} else {
    // No payload received
    http_response_code(400);
    echo 'Error: No payload received.';
}
